<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        font-family: 'Segoe UI', Arial, sans-serif;
        background: #f4f8f9;
    }

    /* ==== Wrapper ==== */
    .order-page {
        width: 95%;
        max-width: 1200px;
        margin: 0 auto;
        /* padding: 60px 0 110px; */
        /* 🔥 lebih kecil */
        min-height: calc(100vh - 100px);
        /* pastikan konten penuh layar */
        display: flex;
        flex-direction: column;
        align-items: stretch;
        justify-content: flex-start;
        /* ✅ dorong card ke atas */
        padding-top: 60px;
        overflow-y: auto;
        /* scroll hanya saat konten lebih tinggi dari layar */

    }


    /* ==== CARD ==== */
    .order-card {
        background: #fff;
        border-radius: 16px;
        padding: 8px;
        margin-bottom: 10px;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
        border-left: 4px solid transparent;
        transition: 0.3s ease;
    }

    .order-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.12);
        border-left: 4px solid #16a085;
    }

    /* ==== HEADER ==== */
    .order-top {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }

    .order-type {
        display: flex;
        align-items: center;
        font-size: 18px;
        font-weight: 600;
        color: #1565C0;
    }

    .order-type i {
        margin-right: 8px;
        color: #16a085;
        font-size: 20px;
    }

    /* ==== STATUS ==== */
    .order-status {
        font-size: 13px;
        font-weight: bold;
        padding: 6px 14px;
        border-radius: 20px;
        color: #fff;
        text-transform: uppercase;
    }

    /* ==== INFORMASI UTAMA ==== */
    .order-info {
        font-size: 15px;
        color: #333;
        display: flex;
        flex-direction: column;
        gap: 6px;
        margin-bottom: 10px;
    }

    .info-row {
        display: flex;
        align-items: flex-start;
        gap: 8px;
    }

    .info-row i {
        color: #16a085;
        flex-shrink: 0;
        font-size: 16px;
        margin-top: 3px;
    }

    .info-text {
        flex: 1;
        line-height: 1.4;
        word-break: break-word;
    }

    .info-text strong {
        color: #000;
        font-weight: 600;
    }

    /* ==== META INFO ==== */
    .order-meta {
        border-top: 1px dashed #ccc;
        margin-top: 10px;
        padding-top: 8px;
        display: flex;
        justify-content: space-between;
        font-size: 14px;
        color: #555;
    }

    .order-meta i {
        color: #2980b9;
        margin-right: 6px;
    }

    /* ==== HARGA ==== */
    .order-price {
        font-size: 22px;
        font-weight: bold;
        color: #1565C0;
        text-align: right;
        margin-top: 10px;
    }

    @media (max-width: 768px) {
        .order-meta {
            flex-direction: column;
            gap: 5px;
        }
    }


    .search-restaurant-wrapper {
        position: fixed;
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        z-index: 100;
        width: 100%;
        max-width: 600px;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        padding: 20px 15px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        border-bottom-left-radius: 15px;
        border-bottom-right-radius: 15px;
        display: flex;
        flex-direction: column;
        gap: 10px;
        height: 60px;
    }

    .status-picking {
        background: #2980b9;
        /* Biru AlfaGo */
        color: #fff;
        animation: pulseStatus 1.5s infinite;
        /* Efek berdenyut lembut */
    }

    /* ✨ Animasi lembut agar status terlihat aktif */
    @keyframes pulseStatus {
        0% {
            transform: scale(1);
            box-shadow: 0 0 0 0 rgba(41, 128, 185, 0.4);
        }

        70% {
            transform: scale(1.05);
            box-shadow: 0 0 0 10px rgba(41, 128, 185, 0);
        }

        100% {
            transform: scale(1);
            box-shadow: 0 0 0 0 rgba(41, 128, 185, 0);
        }
    }

    .status-new {
        background: #16a085;
    }

    .status-driver-to-customer,
    .status-driver-to-resto {
        background: #2980b9;
    }

    .status-processing {
        background: #f1c40f;
    }

    .status-on-trip,
    .status-delivering {
        background: #e67e22;
    }

    .status-cancelled {
        background: #e74c3c;
    }

    .status-completed {
        background: #27ae60;
    }
</style>

<div class="search-restaurant-wrapper"></div>

<div class="order-page">
    <div hidden class="page-header">
        <h2><i class="fa-solid fa-list"></i> Daftar Order</h2>
    </div>

    <?php if (!empty($orders)): ?>
        <?php foreach ($orders as $order): ?>
            <div
                class="order-card"
                data-order-id="<?= $order['order_id'] ?>"
                data-status="<?= $order['order_status'] ?>">

                <div class="order-top">
                    <div class="order-type">
                        <?php if ($order['order_type'] === 'ride'): ?>
                            <i class="fa-solid fa-motorcycle"></i> Ride
                        <?php else: ?>
                            <i class="fa-solid fa-utensils"></i> Food
                        <?php endif; ?>
                    </div>

                    <?php
                    $statusClass = [
                        // ✅ Ride Status
                        'new' => 'status-new',
                        'driver_to_customer' => 'status-driver-to-customer',
                        'on_trip' => 'status-on-trip',
                        'cancelled' => 'status-cancelled',
                        'completed' => 'status-completed',

                        // ✅ Food Status
                        'processing' => 'status-processing',
                        'driver_to_resto' => 'status-driver-to-resto',
                        'delivering' => 'status-delivering'
                    ][$order['order_status']] ?? 'status-new';
                    ?>
                    <div class="order-status <?= $statusClass ?>">
                        <?= strtoupper(str_replace('_', ' ', $order['order_status'])) ?>
                    </div>
                </div>

                <div class="order-info">
                    <div class="info-row">
                        <i class="fa-solid fa-calendar-day"></i>
                        <div class="info-text">
                            Tanggal : <?= date('d/m/Y H:i:s', strtotime($order['created_at'])) ?>
                        </div>

                    </div>
                    <div class="info-row">
                        <i class="fa-solid fa-user"></i>
                        <div class="info-text">Driver : <strong><?= esc($order['driver_name']) ?></strong></div>
                    </div>

                    <div hidden class="info-row">
                        <i class="fa-solid fa-road"></i>
                        <div class="info-text">Jarak : <?= esc($order['distance']) ?> km</div>
                    </div>

                    <div class="info-row">
                        <i class="fa-solid fa-location-dot"></i>
                        <div class="info-text">
                            Pickup : <?= esc($order['pickup']) ?>
                        </div>
                    </div>

                    <div class="info-row">
                        <i class="fa-solid fa-flag-checkered"></i>
                        <div class="info-text">Tujuan : <?= esc($order['destination']) ?></div>
                    </div>
                </div>

                <div hidden class="order-meta">

                </div>

                <div hidden class="order-price">Rp <?= number_format($order['tarif'], 0, ',', '.') ?></div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p style="text-align:center; color:#777;">Belum ada order</p>
    <?php endif; ?>
</div>

<script src="<?= base_url('js/orders.js') ?>"></script>

<?= $this->endSection() ?>